function [firstprofs, stdprofs] = GetProfilesNew(images,size,stdimg)
    %usage: GetProfilesNew(images,size,stdimg)
    %returns an NxN matrix of profiles, where N = length(images)/size
    %each profile is a radial averaging of the image patch it defines
    %if your offset goes from 0:10 pixels, size should be 21
    %if the standard deviation image in included, stdprofs works the same way
    %    
    if nargin < 3 
        stdimg=[]; 
        stdprofs={};
    else
        stdprofs=cell(floor(length(images)/size));
    end

    firstprofs=cell(floor(length(images)/size));

    for y=1:floor(length(images)/size)
        for x= 1:floor(length(images(1,:))/size)
            tmp=double(images((y-1)*size+1:(y)*size,(x-1)*size+1:(x)*size,:));
            outTmp=[];
            if x==1 && y==1
                figure;imshow(tmp)
            end
            for i = 0:15 %sixteen different angles
                px=[ ceil(size/2) ceil(size/2)+floor(size/2)*cos(22.5*i*pi/180) ];
                py=[ ceil(size/2) ceil(size/2)+floor(size/2)*sin(22.5*i*pi/180) ];
                p=improfile(tmp,px,py,ceil(size/2),'bicubic');
                outTmp=cat(2,outTmp,p);
            end
            tmpprof=mean(outTmp');

            if nargin == 3
                tmp=double(stdimg((y-1)*size+1:(y)*size,(x-1)*size+1:(x)*size,:));
                outTmp=[];
                for i = 0:15 %sixteen different angles
                    px=[ ceil(size/2) ceil(size/2)+floor(size/2)*cos(22.5*i*pi/180) ];
                    py=[ ceil(size/2) ceil(size/2)+floor(size/2)*sin(22.5*i*pi/180) ];
                    p=improfile(tmp,px,py,ceil(size/2),'bicubic');
                    outTmp=cat(2,outTmp,p);
                end
                tmpstdprof=mean(outTmp');
                stdprofs{x,y} = tmpstdprof;
            end
            firstprofs{x,y}=tmpprof;
            keyboard
        end
    end

